/*
 * Decompiled with CFR 0.152.
 */
package com.esp8266.mkspiffs;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import org.apache.commons.codec.digest.DigestUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.ProcessUtils;
import processing.app.tools.Tool;

public class ESP8266FS
implements Tool {
    Editor editor;

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "ESP8266 Sketch Data Upload";
    }

    private int listenOnProcess(String[] stringArray) {
        try {
            final Process process = ProcessUtils.exec((String[])stringArray);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.out.print((char)n);
                        }
                        inputStreamReader.close();
                        inputStreamReader = new InputStreamReader(process.getErrorStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.err.print((char)n);
                        }
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            int n = process.waitFor();
            thread.join();
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void sysExec(final String[] stringArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (ESP8266FS.this.listenOnProcess(stringArray) != 0) {
                        ESP8266FS.this.editor.statusError("SPIFFS Upload failed!");
                    } else {
                        ESP8266FS.this.editor.statusNotice("SPIFFS Image Uploaded");
                    }
                }
                catch (Exception exception) {
                    ESP8266FS.this.editor.statusError("SPIFFS Upload failed!");
                }
            }
        };
        thread.start();
    }

    private String getBuildFolderPath(Sketch sketch) {
        try {
            String string = sketch.getBuildPath().getAbsolutePath();
            return string;
        }
        catch (IOException iOException) {
            this.editor.statusError((Exception)iOException);
        }
        catch (Exception exception) {
            try {
                File file = FileUtils.createTempFolder((String)"build", (String)(DigestUtils.md5Hex((String)sketch.getMainFilePath()) + ".tmp"));
                return file.getAbsolutePath();
            }
            catch (IOException iOException) {
                this.editor.statusError((Exception)iOException);
            }
            catch (Exception exception2) {
                try {
                    Method method = BaseNoGui.class.getMethod("getBuildFolder", new Class[0]);
                    File file = (File)method.invoke(null, new Object[0]);
                    return file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    this.editor.statusError((Exception)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.editor.statusError((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.editor.statusError((Exception)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.editor.statusError((Exception)noSuchMethodException);
                }
            }
        }
        return "";
    }

    private long getIntPref(String string) {
        String string2 = (String)BaseNoGui.getBoardPreferences().get((Object)string);
        if (string2 == null || string2.contentEquals("")) {
            return 0L;
        }
        if (string2.startsWith("0x")) {
            return Long.parseLong(string2.substring(2), 16);
        }
        return Integer.parseInt(string2);
    }

    private void createAndUpload() {
        File[] fileArray;
        String string;
        long l;
        long l2;
        long l3;
        long l4;
        if (!PreferencesData.get((String)"target_platform").contentEquals("esp8266")) {
            System.err.println();
            this.editor.statusError("SPIFFS Not Supported on " + PreferencesData.get((String)"target_platform"));
            return;
        }
        if (!BaseNoGui.getBoardPreferences().containsKey((Object)"build.spiffs_start") || !BaseNoGui.getBoardPreferences().containsKey((Object)"build.spiffs_end")) {
            System.err.println();
            this.editor.statusError("SPIFFS Not Defined for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
            return;
        }
        try {
            l4 = this.getIntPref("build.spiffs_start");
            l3 = this.getIntPref("build.spiffs_end");
            l2 = this.getIntPref("build.spiffs_pagesize");
            if (l2 == 0L) {
                l2 = 256L;
            }
            if ((l = this.getIntPref("build.spiffs_blocksize")) == 0L) {
                l = 4096L;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            return;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string2 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "mkspiffs.exe" : "mkspiffs";
        File file = new File(targetPlatform.getFolder() + "/tools", string2);
        if (!(file.exists() && file.isFile() || (file = new File(targetPlatform.getFolder() + "/tools/mkspiffs", string2)).exists() || (file = new File(PreferencesData.get((String)"runtime.tools.mkspiffs.path"), string2)).exists())) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: mkspiffs not found!");
            return;
        }
        Boolean bl = false;
        File file2 = new File(targetPlatform.getFolder() + "/tools");
        File file3 = new File(targetPlatform.getFolder() + "/tools");
        String string3 = PreferencesData.get((String)"serial.port");
        if (string3 == null || string3.isEmpty()) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: serial port not defined!");
            return;
        }
        if (string3.split("\\.").length == 4) {
            bl = true;
            string = "espota.py";
            file2 = new File(targetPlatform.getFolder() + "/tools", string);
            if (!file2.exists() || !file2.isFile()) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: espota not found!");
                return;
            }
        } else {
            string = (String)targetPlatform.getTool("esptool").get((Object)"cmd");
            file3 = new File(targetPlatform.getFolder() + "/tools", string);
            if (!(file3.exists() && file3.isFile() || (file3 = new File(targetPlatform.getFolder() + "/tools/esptool", string)).exists() || (file3 = new File(PreferencesData.get((String)"runtime.tools.esptool.path"), string)).exists())) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: esptool not found!");
                return;
            }
        }
        int n = 0;
        File file4 = new File(this.editor.getSketch().getFolder(), "data");
        if (!file4.exists()) {
            file4.mkdirs();
        }
        if (file4.exists() && file4.isDirectory() && (fileArray = file4.listFiles()).length > 0) {
            for (File object2 : fileArray) {
                if (!object2.isDirectory() && !object2.isFile() || object2.getName().startsWith(".")) continue;
                ++n;
            }
        }
        fileArray = file4.getAbsolutePath();
        File[] fileArray2 = file.getAbsolutePath();
        String string4 = this.editor.getSketch().getName();
        String string5 = this.getBuildFolderPath(this.editor.getSketch()) + "/" + string4 + ".spiffs.bin";
        String string6 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.resetmethod");
        String string7 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.speed");
        String string8 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.spiffs_start");
        Object[] objectArray = new Object[]{"Yes", "No"};
        String string9 = "SPIFFS Create";
        String string10 = "No files have been found in your data folder!\nAre you sure you want to create an empty SPIFFS image?";
        if (n == 0 && JOptionPane.showOptionDialog((Component)this.editor, string10, string9, 0, 3, null, objectArray, objectArray[1]) != 0) {
            System.err.println();
            this.editor.statusError("SPIFFS Warning: mkspiffs canceled!");
            return;
        }
        this.editor.statusNotice("SPIFFS Creating Image...");
        System.out.println("[SPIFFS] data   : " + (String)fileArray);
        System.out.println("[SPIFFS] size   : " + (l3 - l4) / 1024L);
        System.out.println("[SPIFFS] page   : " + l2);
        System.out.println("[SPIFFS] block  : " + l);
        try {
            if (this.listenOnProcess(new String[]{fileArray2, "-c", fileArray, "-p", l2 + "", "-b", l + "", "-s", l3 - l4 + "", string5}) != 0) {
                System.err.println();
                this.editor.statusError("SPIFFS Create Failed!");
                return;
            }
        }
        catch (Exception string102) {
            this.editor.statusError(string102);
            this.editor.statusError("SPIFFS Create Failed!");
            return;
        }
        this.editor.statusNotice("SPIFFS Uploading Image...");
        System.out.println("[SPIFFS] upload : " + string5);
        if (bl.booleanValue()) {
            String string11 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "python.exe" : "python";
            System.out.println("[SPIFFS] IP     : " + string3);
            System.out.println();
            this.sysExec(new String[]{string11, file2.getAbsolutePath(), "-i", string3, "-s", "-f", string5});
        } else {
            System.out.println("[SPIFFS] address: " + string8);
            System.out.println("[SPIFFS] reset  : " + string6);
            System.out.println("[SPIFFS] port   : " + string3);
            System.out.println("[SPIFFS] speed  : " + string7);
            System.out.println();
            this.sysExec(new String[]{file3.getAbsolutePath(), "-cd", string6, "-cb", string7, "-cp", string3, "-ca", string8, "-cf", string5});
        }
    }

    public void run() {
        this.createAndUpload();
    }
}

